<?php
/*--------------------------------------------------------------------
 PropertiesCombinationIdDto.php 2020-06-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitModel\Database\Repository\DTO;

/**
 * Class PropertiesCombinationIdDto
 * @package Gambio\Shop\Properties\SellingUnitModel\Database\Repository\DTO
 */
class PropertiesCombinationIdDto
{
    /**
     * @var int
     */
    protected $combinationId;
    
    
    /**
     * PropertiesCombinationIdDto constructor.
     *
     * @param int $combinationId
     */
    public function __construct(int $combinationId)
    {
        $this->combinationId = $combinationId;
    }
    
    
    /**
     * @return int
     */
    public function combinationId(): int
    {
        return $this->combinationId;
    }
}